import csv
import numpy as np
import matplotlib.pyplot as plt
from matplotlib import pylab

wavelength = []
frequency = []

with open('Calibration_test.csv', 'r') as csvFile:
    reader = csv.reader(csvFile)
    for row in reader:
        wavelength.append(row[0])
        wavelength = list(map(float, wavelength))
        frequency.append(row[1])
        frequency = list(map(float, frequency))
    csvFile.close()

wavelength = np.reciprocal(wavelength)
z = np.polyfit(wavelength, frequency, 4)
z1 = np.polyfit(frequency, wavelength, 4)
f = np.poly1d(z)
f1 = np.poly1d(z1)
print(z[1])
print(f)
print(f1)

x_new = np.linspace(wavelength[0], wavelength[-1], 100)
y_new = f(x_new)

plt.plot(frequency, wavelength, 'o', y_new, x_new)
pylab.title('Polynomial Fit with Matplotlib')
plt.show()
